<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add Employee</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-7">
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white text-center">
                        <h4>➕ Add New Employee</h4>
                    </div>
                    <div class="card-body">
                        <form method="post" class="row g-3">
                            <!-- Name -->
                            <div class="col-md-6">
                                <label class="form-label">Full Name</label>
                                <input type="text" class="form-control" name="name" required>
                            </div>
                            <!-- Email -->
                            <div class="col-md-6">
                                <label class="form-label">Email</label>
                                <input type="email" class="form-control" name="email">
                            </div>
                            <!-- Phone -->
                            <div class="col-md-6">
                                <label class="form-label">Phone</label>
                                <input type="text" class="form-control" name="phone">
                            </div>
                            <!-- Position -->
                            <div class="col-md-6">
                                <label class="form-label">Position</label>
                                <input type="text" class="form-control" name="position">
                            </div>
                            <!-- Address -->
                            <div class="col-md-12">
                                <label class="form-label">Address</label>
                                <textarea class="form-control" name="address" rows="2"></textarea>
                            </div>
                            <!-- Status -->
                            <div class="col-md-6">
                                <label class="form-label">Status</label>
                                <select class="form-select" name="status">
                                    <option value="Active">Active</option>
                                    <option value="Inactive">Inactive</option>
                                </select>
                            </div>
                            <!-- Date Joined -->
                            <div class="col-md-6">
                                <label class="form-label">Date Joined</label>
                                <input type="date" class="form-control" name="date_joined">
                            </div>
                            <!-- Date Left -->
                            <div class="col-md-6">
                                <label class="form-label">Date Left</label>
                                <input type="date" class="form-control" name="date_left">
                            </div>
                            <!-- Buttons -->
                            <div class="col-12 text-end">
                                <a href="index.php" class="btn btn-secondary">⬅ Back</a>
                                <button type="submit" name="save" class="btn btn-success">💾 Save Employee</button>
                            </div>
                        </form>
                    </div>
                </div>
                <?php
                if(isset($_POST['save'])){
                    $stmt = $conn->prepare("INSERT INTO employees (name, email, phone, address, status, date_joined, date_left, position) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                    $stmt->bind_param("ssssssss", $_POST['name'], $_POST['email'], $_POST['phone'], $_POST['address'], $_POST['status'], $_POST['date_joined'], $_POST['date_left'], $_POST['position']);
                    $stmt->execute();
                    echo "<div class='alert alert-success mt-3'>✅ Employee added successfully. <a href='index.php' class='alert-link'>View List</a></div>";
                }
                ?>
            </div>
        </div>
    </div>
</body>
</html>
