<?php include 'db.php'; ?>
<!DOCTYPE html>
<html>
<head>
    <title>Create Quotation - VSONIC ENGINEERING</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background:#f4f6f9; }
        .quotation-box { background:white; padding:20px; border-radius:10px; box-shadow:0 2px 5px rgba(0,0,0,0.1); }
    </style>
</head>
<body class="p-4">

<div class="quotation-box">
    <h3 class="mb-3">VSONIC ENGINEERING - Create Quotation</h3>
    <form method="POST" action="save_quotation.php">
        <div class="mb-3">
            <label>Business Partner Name</label>
            <input type="text" name="partner_name" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Business Partner Address</label>
            <textarea name="partner_address" class="form-control" rows="3"></textarea>
        </div>

        <table class="table table-bordered" id="itemsTable">
            <thead>
                <tr>
                    <th>Description</th>
                    <th width="120">Quantity</th>
                    <th width="150">Unit Price</th>
                    <th width="150">Total</th>
                    <th width="50">Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><input type="text" name="description[]" class="form-control" required></td>
                    <td><input type="number" name="quantity[]" class="form-control qty" value="1" min="1"></td>
                    <td><input type="number" name="unit_price[]" class="form-control price" step="0.01" value="0.00"></td>
                    <td><input type="text" name="total[]" class="form-control total" readonly></td>
                    <td><button type="button" class="btn btn-danger btn-sm removeRow">X</button></td>
                </tr>
            </tbody>
        </table>
        <button type="button" id="addRow" class="btn btn-secondary btn-sm mb-3">+ Add Item</button>

        <div class="form-check mb-3">
            <input class="form-check-input" type="checkbox" name="sst_enabled" value="1" id="sstCheck">
            <label class="form-check-label" for="sstCheck">Apply 8% SST</label>
        </div>

        <h4 class="text-end">Grand Total: <span id="grandTotal">0.00</span></h4>

        <button type="submit" class="btn btn-success">Save Quotation</button>
    </form>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function updateTotals() {
    let grandTotal = 0;
    $("#itemsTable tbody tr").each(function(){
        let qty = parseFloat($(this).find(".qty").val()) || 0;
        let price = parseFloat($(this).find(".price").val()) || 0;
        let total = qty * price;
        $(this).find(".total").val(total.toFixed(2));
        grandTotal += total;
    });

    if($("#sstCheck").is(":checked")) {
        grandTotal *= 1.08; // apply SST
    }

    $("#grandTotal").text(grandTotal.toFixed(2));
}

$(document).on("input change", ".qty, .price, #sstCheck", updateTotals);

$("#addRow").click(function(){
    $("#itemsTable tbody").append(`
        <tr>
            <td><input type="text" name="description[]" class="form-control" required></td>
            <td><input type="number" name="quantity[]" class="form-control qty" value="1" min="1"></td>
            <td><input type="number" name="unit_price[]" class="form-control price" step="0.01" value="0.00"></td>
            <td><input type="text" name="total[]" class="form-control total" readonly></td>
            <td><button type="button" class="btn btn-danger btn-sm removeRow">X</button></td>
        </tr>
    `);
});

$(document).on("click", ".removeRow", function(){
    $(this).closest("tr").remove();
    updateTotals();
});

updateTotals();
</script>
</body>
</html>
