<?php 
include 'db.php'; 
$id = $_GET['id'] ?? 0;

// Fetch existing payment
$payment = $conn->query("
    SELECT p.*, e.name AS employee 
    FROM payments p 
    JOIN employees e ON p.employee_id = e.id 
    WHERE p.id = $id
")->fetch_assoc();

// Handle update
if(isset($_POST['update'])){
    $stmt = $conn->prepare("UPDATE payments 
        SET employee_id=?, amount=?, payment_date=?, method=?, remarks=? 
        WHERE id=?");
    $stmt->bind_param(
        "idsssi", 
        $_POST['employee_id'], 
        $_POST['amount'], 
        $_POST['payment_date'], 
        $_POST['method'], 
        $_POST['remarks'], 
        $id
    );
    $stmt->execute();
    echo "<div class='alert alert-success text-center'>✅ Payment updated successfully. 
          <a href='payment_list.php' class='alert-link'>Back to Payments</a></div>";
}

// Handle delete
if(isset($_POST['delete'])){
    $conn->query("DELETE FROM payments WHERE id=$id");
    echo "<div class='alert alert-danger text-center'>🗑️ Payment deleted successfully. 
          <a href='payment_list.php' class='alert-link'>Back to Payments</a></div>";
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Payment</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <script>
        function confirmDelete(){
            return confirm("⚠️ Are you sure you want to delete this payment? This action cannot be undone.");
        }
    </script>
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8 col-md-10">
            <div class="card shadow-lg border-0 rounded-3">
                <div class="card-header bg-warning text-dark">
                    <h4 class="mb-0">✏️ Edit Payment</h4>
                </div>
                <div class="card-body">
                    <form method="post">

                        <!-- Employee -->
                        <div class="mb-3">
                            <label for="employee_id" class="form-label">Employee</label>
                            <select class="form-select" id="employee_id" name="employee_id" required>
                                <?php
                                $res = $conn->query("SELECT id, name FROM employees WHERE status='Active'");
                                while($emp = $res->fetch_assoc()){
                                    $selected = ($emp['id'] == $payment['employee_id']) ? "selected" : "";
                                    echo "<option value='{$emp['id']}' $selected>{$emp['name']}</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <!-- Amount -->
                        <div class="mb-3">
                            <label for="amount" class="form-label">Amount (RM)</label>
                            <input type="number" step="0.01" class="form-control" id="amount" 
                                   name="amount" value="<?= $payment['amount'] ?>" required>
                        </div>

                        <!-- Payment Date -->
                        <div class="mb-3">
                            <label for="payment_date" class="form-label">Payment Date</label>
                            <input type="date" class="form-control" id="payment_date" 
                                   name="payment_date" value="<?= $payment['payment_date'] ?>" required>
                        </div>

                        <!-- Method -->
                        <div class="mb-3">
                            <label for="method" class="form-label">Payment Method</label>
                            <select class="form-select" id="method" name="method">
                                <?php 
                                $methods = ['Cash','Bank Transfer','Cheque'];
                                foreach($methods as $m){
                                    $sel = ($m == $payment['method']) ? "selected" : "";
                                    echo "<option value='$m' $sel>$m</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <!-- Remarks -->
                        <div class="mb-3">
                            <label for="remarks" class="form-label">Remarks</label>
                            <textarea class="form-control" id="remarks" 
                                      name="remarks" rows="3"><?= $payment['remarks'] ?></textarea>
                        </div>

                        <!-- Buttons -->
                        <div class="d-flex justify-content-between">
                            <a href="payment_list.php" class="btn btn-outline-secondary">⬅ Back</a>
                            <div>
                                <button type="submit" name="update" class="btn btn-warning">💾 Update</button>
                                <button type="submit" name="delete" class="btn btn-danger" onclick="return confirmDelete();">🗑️ Delete</button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
