<?php
include 'db.php';

$result = $conn->query("SELECT * FROM invoices ORDER BY id DESC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Invoices - VSONIC ENGINEERING</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4 bg-light">

<div class="container bg-white p-4 rounded shadow">
    <h3 class="mb-4">Invoices</h3>
    <a href="create_invoice.php" class="btn btn-primary mb-3">+ New Invoice</a>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Partner</th>
                <th>Address</th>
                <th>Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $result->fetch_assoc()) { ?>
                <tr>
                    <td>#<?php echo $row['id']; ?></td>
                    <td><?php echo htmlspecialchars($row['partner_name']); ?></td>
                    <td><?php echo nl2br(htmlspecialchars($row['partner_address'])); ?></td>
                    <td><?php echo $row['created_at']; ?></td>
                    <td>
                        <a href="view_invoice.php?id=<?php echo $row['id']; ?>" class="btn btn-info btn-sm">View</a>
                        <a href="create_invoice.php?quotation_id=<?php echo $row['quotation_id']; ?>&edit=<?php echo $row['id']; ?>" class="btn btn-warning btn-sm">Edit</a>
                        <a href="export_invoice_pdf.php?id=<?php echo $row['id']; ?>" class="btn btn-danger btn-sm">PDF</a>
                    </td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
</div>
</body>
</html>
