<?php
session_start();
if (isset($_SESSION['username'])) {
    header("Location: dashboard.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>VSONIC ENGINEERING MANAGEMENT SYSTEM - Login</title>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;

            /* Background with image + overlay */
            background: linear-gradient(rgba(179, 18, 23, 0.8), rgba(50, 0, 0, 0.8)),
                        url('bg-electrical.jpg') no-repeat center center fixed;
            background-size: cover;
            color: #fff;
        }

        .container {
            text-align: center;
            width: 100%;
        }

        .login-box {
            background: rgba(255, 255, 255, 0.95);
            color: #333;
            padding: 40px 30px;
            border-radius: 15px;
            box-shadow: 0 8px 20px rgba(0,0,0,0.4);
            width: 380px;
            margin: auto;
            position: relative;
            animation: fadeIn 1s ease;
        }

        .login-box img {
            width: 80px;
            margin-bottom: 10px;
        }

        h1 {
            margin-bottom: 20px;
            font-size: 20px;
            color: #b31217;
            font-weight: bold;
        }

        input[type="text"], input[type="password"] {
            width: 100%;
            padding: 12px;
            margin: 10px 0;
            border-radius: 8px;
            border: 1px solid #ccc;
            font-size: 14px;
        }

        input[type="submit"] {
            width: 100%;
            background: #b31217;
            color: white;
            padding: 12px;
            border: none;
            border-radius: 8px;
            font-size: 15px;
            cursor: pointer;
            transition: background 0.3s ease, transform 0.2s ease;
        }

        input[type="submit"]:hover {
            background: #8a0f12;
            transform: translateY(-2px);
        }

        .clock {
            margin-top: 15px;
            font-size: 16px;
            color: #555;
            font-weight: bold;
        }

        footer {
            position: absolute;
            bottom: 15px;
            width: 100%;
            text-align: center;
            font-size: 13px;
            color: #f5f5f5;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: scale(0.9); }
            to { opacity: 1; transform: scale(1); }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="login-box">
            <!-- Company Logo -->
            <img src="logo.png" alt="Company Logo">

            <!-- Title -->
            <h1>VSONIC ENGINEERING MANAGEMENT SYSTEM</h1>

            <!-- Login Form -->
            <form action="authenticate.php" method="POST">
                <input type="text" name="username" placeholder="Enter Username" required>
                <input type="password" name="password" placeholder="Enter Password" required>
                <input type="submit" value="Login">
            </form>

            <!-- Clock Widget -->
            <div class="clock" id="clock"></div>
        </div>
    </div>

    <!-- Footer -->
    <footer>
        &copy; <?php echo date("Y"); ?> VSONIC Engineering. All rights reserved.
    </footer>

    <script>
        function updateClock() {
            const now = new Date();
            const time = now.toLocaleTimeString();
            document.getElementById('clock').textContent = time;
        }
        setInterval(updateClock, 1000);
        updateClock();
    </script>
</body>
</html>
