<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Make Payment</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="card shadow-lg">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">💳 Make Payment to Employee</h4>
        </div>
        <div class="card-body">
            <form method="post">
                <!-- Employee -->
                <div class="mb-3">
                    <label for="employee_id" class="form-label">Employee</label>
                    <select class="form-select" id="employee_id" name="employee_id" required>
                        <option value="">-- Select Employee --</option>
                        <?php
                        $res = $conn->query("SELECT id, name FROM employees WHERE status='Active'");
                        while($emp = $res->fetch_assoc()){
                            echo "<option value='{$emp['id']}'>{$emp['name']}</option>";
                        }
                        ?>
                    </select>
                </div>

                <!-- Amount -->
                <div class="mb-3">
                    <label for="amount" class="form-label">Amount (RM)</label>
                    <input type="number" step="0.01" class="form-control" id="amount" name="amount" placeholder="Enter amount" required>
                </div>

                <!-- Payment Date -->
                <div class="mb-3">
                    <label for="payment_date" class="form-label">Payment Date</label>
                    <input type="date" class="form-control" id="payment_date" name="payment_date" value="<?= date('Y-m-d') ?>" required>
                </div>

                <!-- Payment Method -->
                <div class="mb-3">
                    <label for="method" class="form-label">Payment Method</label>
                    <select class="form-select" id="method" name="method">
                        <option value="Cash">Cash</option>
                        <option value="Bank Transfer">Bank Transfer</option>
                        <option value="Cheque">Cheque</option>
                    </select>
                </div>

                <!-- Remarks -->
                <div class="mb-3">
                    <label for="remarks" class="form-label">Remarks</label>
                    <textarea class="form-control" id="remarks" name="remarks" rows="3" placeholder="Optional notes"></textarea>
                </div>

                <!-- Buttons -->
                <div class="d-flex justify-content-between">
                    <a href="payment_list.php" class="btn btn-outline-secondary">📋 View Payments</a>
                    <div>
                        <a href="index.php" class="btn btn-secondary">⬅ Back</a>
                        <button type="submit" name="pay" class="btn btn-primary">💾 Submit Payment</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <?php
    if(isset($_POST['pay'])){
        $stmt = $conn->prepare("INSERT INTO payments (employee_id, amount, payment_date, method, remarks) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("idsss", $_POST['employee_id'], $_POST['amount'], $_POST['payment_date'], $_POST['method'], $_POST['remarks']);
        $stmt->execute();
        echo "<div class='alert alert-success mt-3'>✅ Payment recorded successfully. <a href='payment_list.php' class='alert-link'>View Logs</a></div>";
    }
    ?>
</div>
</body>
</html>
