<?php
require('fpdf/fpdf.php');
include 'db.php';

$id = $_GET['id'];

// Get employee info
$emp = $conn->query("SELECT * FROM employees WHERE id=$id")->fetch_assoc();

// Create PDF
$pdf = new FPDF();
$pdf->AddPage();

// Header
$pdf->SetFont('Arial','B',16);
$pdf->Cell(0,10,'Employee Payment History',0,1,'C');
$pdf->Ln(5);

// Employee Info
$pdf->SetFont('Arial','',12);
$pdf->Cell(0,10,"Name: {$emp['name']}",0,1);
$pdf->Cell(0,10,"Email: {$emp['email']}",0,1);
$pdf->Cell(0,10,"Phone: {$emp['phone']}",0,1);
$pdf->Cell(0,10,"Position: {$emp['position']}",0,1);
$pdf->Cell(0,10,"Status: {$emp['status']}",0,1);
$pdf->Cell(0,10,"Joined: {$emp['date_joined']}   Left: {$emp['date_left']}",0,1);
$pdf->Ln(10);

// Table Header
$pdf->SetFont('Arial','B',10);
$pdf->Cell(15,10,'ID',1);
$pdf->Cell(30,10,'Amount',1);
$pdf->Cell(30,10,'Pay Date',1);
$pdf->Cell(35,10,'Method',1);
$pdf->Cell(70,10,'Remarks',1);
$pdf->Ln();

// Table Rows
$pdf->SetFont('Arial','',10);
$result = $conn->query("SELECT * FROM payments WHERE employee_id=$id ORDER BY id DESC");
$total = 0;
while($row = $result->fetch_assoc()){
    $pdf->Cell(15,10,$row['id'],1);
    $pdf->Cell(30,10,number_format($row['amount'],2),1);
    $pdf->Cell(30,10,$row['payment_date'],1);
    $pdf->Cell(35,10,$row['method'],1);
    $pdf->Cell(70,10,$row['remarks'],1);
    $pdf->Ln();
    $total += $row['amount'];
}

// Total
$pdf->SetFont('Arial','B',12);
$pdf->Cell(110,10,'Total Paid',1);
$pdf->Cell(70,10,number_format($total,2),1);

$pdf->Output();
?>