<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Employee Payments</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="card shadow-lg">
        <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
            <h4 class="mb-0">📋 Employee Payments</h4>
            <a href="payment_add.php" class="btn btn-light btn-sm">➕ Make New Payment</a>
        </div>
        <div class="card-body">
            <table class="table table-striped table-hover align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Employee</th>
                        <th>Amount (RM)</th>
                        <th>Payment Date</th>
                        <th>Method</th>
                        <th>Remarks</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                $res = $conn->query("SELECT p.*, e.name FROM payments p 
                                     JOIN employees e ON p.employee_id = e.id 
                                     ORDER BY p.payment_date DESC");
                if($res->num_rows > 0){
                    $i=1;
                    while($row = $res->fetch_assoc()){
                        echo "<tr>
                            <td>{$i}</td>
                            <td>{$row['name']}</td>
                            <td><span class='badge bg-primary'>".number_format($row['amount'],2)."</span></td>
                            <td>".date("d M Y", strtotime($row['payment_date']))."</td>
                            <td>{$row['method']}</td>
                            <td>{$row['remarks']}</td>
                            <td>
                                <a href='edit_payment.php?id={$row['id']}' class='btn btn-sm btn-warning'>✏ Edit</a>
                                <a href='edit_payment.php?id={$row['id']}' class='btn btn-sm btn-danger' onclick=\"return confirm('Delete this payment?')\">🗑 Delete</a>
                            </td>
                        </tr>";
                        $i++;
                    }
                } else {
                    echo "<tr><td colspan='7' class='text-center text-muted'>No payments found</td></tr>";
                }
                ?>
                </tbody>
            </table>
            <div class="mt-3">
                <a href="index.php" class="btn btn-secondary">⬅ Back to Employees</a>
            </div>
        </div>
    </div>
</div>
</body>
</html>
