<?php
include 'db.php';
$id = intval($_GET['id']);
$payroll = $conn->query("SELECT p.*, e.name AS employee_name FROM payrolls p JOIN employees e ON p.employee_id=e.id WHERE p.id=$id")->fetch_assoc();
if (!$payroll) die("Payroll not found");

if (isset($_POST['update'])) {
    $basic = floatval($_POST['basic']);
    $allowances = floatval($_POST['allowances']);
    $ot = floatval($_POST['ot']);
    $status = $_POST['status'];

    $gross = $basic + $allowances + $ot;

    // recompute deductions from JSON
    $deductions = json_decode($payroll['deductions'], true) ?? [];
    $total_deductions = 0;
    foreach($deductions as $d){ $total_deductions += floatval($d['amount']); }

    $net = $gross - $total_deductions;

    $stmt = $conn->prepare("UPDATE payrolls SET basic=?, allowances=?, ot=?, gross=?, total_deductions=?, net_pay=?, status=? WHERE id=?");
    $stmt->bind_param("dddddsii", $basic, $allowances, $ot, $gross, $total_deductions, $net, $status, $id);
    $stmt->execute();

    // log update
    $details = "Updated payroll: Basic=$basic, Allowances=$allowances, OT=$ot, Status=$status";
    $conn->query("INSERT INTO payroll_logs (payroll_id, action, actor, details) VALUES ($id, 'updated','admin','". $conn->real_escape_string($details) ."')");

    echo "<script>alert('✅ Payroll updated'); window.location='payroll_list.php?month={$payroll['payroll_month']}';</script>";
    exit;
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Payroll</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
    <h3>✏️ Edit Payroll - <?= htmlspecialchars($payroll['employee_name']) ?> (<?= htmlspecialchars($payroll['payroll_month']) ?>)</h3>
    <form method="post" class="card p-4">
        <div class="mb-3">
            <label class="form-label">Basic</label>
            <input type="number" step="0.01" class="form-control" name="basic" value="<?= htmlspecialchars($payroll['basic']) ?>" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Allowances</label>
            <input type="number" step="0.01" class="form-control" name="allowances" value="<?= htmlspecialchars($payroll['allowances']) ?>">
        </div>
        <div class="mb-3">
            <label class="form-label">Overtime</label>
            <input type="number" step="0.01" class="form-control" name="ot" value="<?= htmlspecialchars($payroll['ot']) ?>">
        </div>
        <div class="mb-3">
            <label class="form-label">Status</label>
            <select name="status" class="form-select">
                <option value="Pending" <?= ($payroll['status']=='Pending')?'selected':'' ?>>Pending</option>
                <option value="Issued" <?= ($payroll['status']=='Issued')?'selected':'' ?>>Issued</option>
                <option value="Cancelled" <?= ($payroll['status']=='Cancelled')?'selected':'' ?>>Cancelled</option>
            </select>
        </div>
        <div class="d-flex justify-content-between">
            <a href="payroll_list.php?month=<?= htmlspecialchars($payroll['payroll_month']) ?>" class="btn btn-secondary">⬅ Back</a>
            <button type="submit" name="update" class="btn btn-success">💾 Save Changes</button>
        </div>
    </form>
</body>
</html>
