<?php
include 'db.php';
$result = $conn->query("SELECT * FROM quotations ORDER BY date_created DESC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Quotations List - VSONIC ENGINEERING</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">

<h3>Quotations Raised</h3>
<a href="create_quotation.php" class="btn btn-primary mb-3">+ New Quotation</a>

<table class="table table-bordered">
    <thead>
        <tr>
            <th>ID</th>
            <th>Partner</th>
            <th>Date</th>
            <th>SST</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php while($row = $result->fetch_assoc()){ ?>
            <tr>
                <td><?php echo $row['id']; ?></td>
                <td><?php echo $row['partner_name']; ?></td>
                <td><?php echo $row['date_created']; ?></td>
                <td><?php echo $row['sst_enabled'] ? 'Yes' : 'No'; ?></td>
                <td>
                    <a href="view_quotation.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-info">View</a>
                    <a href="edit_quotation.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
                    <a href="export_quotation_pdf.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-success">Download PDF</a>
                </td>
            </tr>
        <?php } ?>
    </tbody>
</table>

</body>
</html>
