<?php
include 'db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $partner_name = $_POST['partner_name'];
    $partner_address = $_POST['partner_address'];
    $sst_enabled = isset($_POST['sst_enabled']) ? 1 : 0;

    $stmt = $conn->prepare("INSERT INTO quotations (partner_name, partner_address, sst_enabled) VALUES (?, ?, ?)");
    $stmt->bind_param("ssi", $partner_name, $partner_address, $sst_enabled);
    $stmt->execute();
    $quotation_id = $stmt->insert_id;

    foreach ($_POST['description'] as $i => $desc) {
        $qty = $_POST['quantity'][$i];
        $price = $_POST['unit_price'][$i];
        $total = $qty * $price;
        $stmtItem = $conn->prepare("INSERT INTO quotation_items (quotation_id, description, quantity, unit_price, total) VALUES (?, ?, ?, ?, ?)");
        $stmtItem->bind_param("isidd", $quotation_id, $desc, $qty, $price, $total);
        $stmtItem->execute();
    }

    header("Location: quotations_list.php?success=1");
    exit();
}
?>
